/*
 * HAL API:
 * Functions for the SDL timers
 *
 * $Id: app_timer.c 63 2008-10-26 19:28:25Z gerry $
 */

#include <avr/interrupt.h>
#include "app_timer.h"

static unsigned short hires_ticks;

SIGNAL(SIG_OUTPUT_COMPARE2)
{
  // reset the counter
  TCNT2 = 0;
  // software timer, ticks the SDL timers. Always running continuously.
  hires_ticks++;
}

void timer_init(void)
{
  // set up timer/counter hardware
  cli();
  // Set up Timer/Counter 2 (8bit) for the timer tick. Uses prescaler of 1024
  TCCR2 = 0x07; /* 00000111B -> prescaler 1024 */
  // set timer/counter end value for 10 ms period
  OCR2 = MSEC_10_DVDR;
  // reset the counter
  TCNT2 = 0;
  // enable the timer interrupt
  TIMSK |= _BV(OCIE2);
  // reset software timer
  hires_ticks = 0;
  sei();
}

unsigned short get_ticks(void)
{
  return hires_ticks;
}
