#ifndef _APP_TIMER_H
#define _APP_TIMER_H
/*
 * HAL API:
 * Interface definitions for the SDL timers.
 * Using Timer/Counter 0 (8 bit) as a time base,
 * with the prescaled clock (period of 64 us).
 * This timer is the base for the hi-res timer
 * (tick = 10 ms)
 *
 * $Id: app_timer.h 63 2008-10-26 19:28:25Z gerry $
 */

#include "services.h"

/* The divider for 10 ms for the prescaler settings */
#define MSEC_10_DVDR (10000 / P_TC0)

/* The counter (divider) for the 1 s timer */
#define SEC_1_DVDR (1000 / 40)

extern void timer_init(void);
extern unsigned short get_ticks(void);

#endif //_APP_TIMER_H

