#ifndef _KEY_H
#define _KEY_H
/*
 * HAL API:
 * Key driver declarations
 *
 * $Id: key.h 65 2008-10-28 19:41:46Z gerry $
 */

#ifdef __AVR
#include <avr/interrupt.h>
#include "kernel_if.h"      // for 'msgID_t', 'ivect_t', 'SendMsg()'

/* LCD port connections */
#define KEY_DATA_PORT PORTD
#define KEY_DATA_PINS PIND
#define KEY_DATA_DDIR DDRD
#define KEY_1 PORT2

#define KEY_DATA_INP  ~(_BV(KEY_1))
#define KEY_DATA_INIT ~(_BV(KEY_1))

#define IVECT_TASTER_1 (ivect_t)(2)

// time interval in ms before a change is acknowledged
#define KEY_DEBOUNCE_TIME 20

// internal id's for all used keys:
typedef enum
{
  ID_TASTER_1,
  NUM_KEYS
} key_id_t;

#endif //__AVR

/* for the signal parameter */
#define KEY_PRESSED  0
#define KEY_RELEASED 1

#ifdef __AVR
/*
 * Perform KEY startup initialization.
 */
extern void key_init(void);

/*
 * Register for key interrupts.
 */
extern void key_signal(ivect_t v, msgId_t m);


#else // for the SDL host simulation

#define key_signal(v,m)

#endif //__AVR
#endif //_KEY_H
