#ifndef _LCD_H
#define _LCD_H
/*
 * HAL API:
 * LCD driver declarations
 *
 * $Id: lcd.h 53 2008-10-21 19:03:44Z gerry $
 */

#ifdef __AVR
/* LCD port connections */
#define LCD_DATA_PORT PORTC
#define LCD_DATA_PINS PINC
#define LCD_DATA_DDIR DDRC
#define LCD_D4 PORT0
#define LCD_D5 PORT1
#define LCD_D6 PORT2
#define LCD_D7 PORT3
#define LCD_BF LCD_D7

#define LCD_CTRL_PORT PORTB
#define LCD_CTRL_DDIR DDRB
#define LCD_RS PORT0
#define LCD_RW PORT1
#define LCD_E  PORT2

#define LCD_DATA_OUTP ((1<<LCD_D4)|(1<<LCD_D5)|(1<<LCD_D6)|(1<<LCD_D7))
#define LCD_DATA_INIT ((1<<LCD_D4)|(1<<LCD_D5)|(1<<LCD_D6)|(1<<LCD_D7))

#define LCD_CTRL_OUTP ((1<<LCD_RS)|(1<<LCD_RW)|(1<<LCD_E))
#define LCD_CTRL_INIT ((1<<LCD_RS)|(1<<LCD_RW)|(1<<LCD_E))


/* LCD commands */
#define LCD_SYSTEM_SET_2_LINES_5x7_CHAR 0x28
#define LCD_MODE_SET_INC_CURSOR         0x06
#define LCD_CLEAR_DISPLAY               0x01
#define LCD_CURSOR_HOME                 0x02
#define LCD_DISPLAY_OFF_CURSOR_OFF      0x08
#define LCD_DISPLAY_ON_CURSOR_ON        0x0E
#define LCD_DISPLAY_ON_CURSOR_OFF       0x0C
#define LCD_SET_DD_RAM_ADDR(A) (0x80|((A)&0x7F))

#define LCD_ADDR_LINE_0 0x00
#define LCD_ADDR_LINE_1 0x40
#endif //__AVR

#define LCD_NUM_LINES 2
#define LCD_NUM_CHARS 16

#ifdef __AVR
/*
 * Perform LCD startup initialization.
 */
extern void lcd_init(void);

/*
 * Send null terminated string s to line l of the LCD
 */
extern void lcd_write(char *s, char l);

/*
 * Set character at the current cursor position of the LCD
 */
extern void lcd_putc(char c);

/*
 * Place (seek) cursor at position r on line l of the LCD
 */
extern void lcd_seek(char r, char l);

#else // for the SDL host simulation

#define lcd_write(x,l) \
  printf("LCD: %s%s\n",((l == 0)?" ":"________________ "),x)

#define lcd_putc(x) \
  printf("LCD:  %c\n",x)

#define lcd_seek(x,y) \
  printf("LCD: set cursor at <"#x"> on line <"#y">.\n")

#endif //__AVR
#endif //_LCD_H
