/*
 * LED (and Buzzer) control functions implementation
 *
 * NOTE: currently only writing to the LCD is used by this driver;
 *       i.e. the RW line is initialised low (0) and left at that,
 *       it is assumed that no part of the program changes that.
 *       The only exception is the _lcd_check_busy() routine which
 *       temporarily sets RW high (1) to read the busy flag.
 *
 * $Id: led.c 53 2008-10-21 19:03:44Z gerry $
 */

#include "defines.h"
#include <avr/io.h>
#include "services.h"
#include "led.h"

/* ===== module variables ===== */
static char led_state[NUM_LEDS];

/* ===== local utility functions ===== */


/*
 * Perform LED startup initialization.
 */
void led_init(void)
{
register unsigned char i;
      /* set all bits to 0 */
    LED_DATA_PORT &= ~(_BV(LED_1)|_BV(LED_2)|_BV(BUZZER));
      /* set bits to output */
    LED_DATA_DDIR |=  (_BV(LED_1)|_BV(LED_2)|_BV(BUZZER));
    for(i = 0; i < NUM_LEDS; i++)
    {
        led_state[i] = LED_OFF;
    }
}

/*
 * Turn LED 'l' on
 */
void led_on(led_t l)
{
    led_state[l] = LED_ON;
    switch (l)
    {
    case LED1:
        LED_DATA_PORT |=  (_BV(LED_1));
        break;
    case LED2:
        LED_DATA_PORT |=  (_BV(LED_2));
        break;
    default:
        break;
    }
}

/*
 * Turn LED 'l' off
 */
void led_off(led_t l)
{
    led_state[l] = LED_OFF;
    switch (l)
    {
    case LED1:
        LED_DATA_PORT &= ~(_BV(LED_1));
        break;
    case LED2:
        LED_DATA_PORT &= ~(_BV(LED_2));
        break;
    default:
        break;
    }
}

/*
 * Toggle LED 'l'
 */
void led_toggle(led_t l)
{
    if (led_state[l] == LED_OFF)
    {
        led_state[l] = LED_ON;
        led_on(l);
    }
    else
    {
        led_state[l] = LED_OFF;
        led_off(l);
    }
}

/*
 * Sound buzzer for 't' milliseconds
 */
void buzz(int t)
{
    LED_DATA_PORT |=  (_BV(BUZZER));
    _delay_ms(t);
    LED_DATA_PORT &= ~(_BV(BUZZER));
}
