#ifndef _LED_H
#define _LED_H
/*
 * HAL API:
 * LED driver declarations
 * (includes Buzzer functions too)
 *
 * $Id: led.h 53 2008-10-21 19:03:44Z gerry $
 */

#ifdef __AVR
/* LED port connections */
#define LED_DATA_PORT PORTD
#define LED_DATA_PINS PIND
#define LED_DATA_DDIR DDRD
#define LED_1 PORT5
#define LED_2 PORT6

/* Buzzer port connections */
#define BUZZER PORT7
#endif //__AVR

typedef enum
{
    LED_OFF = 0,
    LED_ON
} led_state_t;

typedef enum
{
    LED1 = 0,
    LED2,
    NUM_LEDS
} led_t;

#ifdef __AVR
/*
 * Perform LED startup initialization.
 */
extern void led_init(void);

/*
 * Turn LED 'l' on
 */
extern void led_on(led_t l);

/*
 * Turn LED 'l' off
 */
extern void led_off(led_t l);

/*
 * Toggle LED 'l'
 */
extern void led_toggle(led_t l);

/*
 * Sound buzzer for 't' milliseconds
 */
extern void buzz(int t);

#else // for the SDL host simulation

#define led_on(x) \
  printf("LED <"#x"> is  on.\n")

#define led_off(x) \
  printf("LED <"#x"> is off.\n")

#define led_toggle(x) \
  printf("LED <"#x"> toggled.\n")

#define buzz(x) \
  printf("Sound buzzer for "#x" ms.\007\n")

#endif //__AVR
#endif //_LED_H
