/*
 * HAL API:
 * Universal service routines
 *
 * $Id: services.c 53 2008-10-21 19:03:44Z gerry $
 */

#include "defines.h"
#include <avr/io.h>
#include <compat/ina90.h>
#include "services.h"

/*
 * Initialize the services module
 */
void services_init(void)
{
    /* Set up Timer/Counter 0 (8bit) for the timing
       of the delay. Uses prescaler of 1024 */
    TCCR0 = 0x05; /* 00000101B -> prescaler 1024 */
}

/*
 * Delay about 't' ms, busy wait !
 * 1 <= 't' <= 255
 */
void _delay_ms(unsigned char t)
{
    while (t > MAX_DELAY_8BIT)
    {
        _delay_ms(MAX_DELAY_8BIT);
        t -= MAX_DELAY_8BIT;
    }
    TCNT0 = CTR_8BIT(t);         /* set the counter */
    TIFR |= _BV(TOV0);           /* clear the overflow bit */
    while (!(TIFR & _BV(TOV0))); /* wait for overflow */
}
