#ifndef _SERVICES_H
#define _SERVICES_H
/*
 *
 * Universal services used by other
 * program modules
 *
 * $Id: services.h 31 2008-09-19 17:24:44Z gerry $
 */

#include "defines.h"

/* definition of the prescaled timer clock (us) */
/* at 16 MHz --> 64 us */
#define P_TC0 (1024 / (F_CPU / 1000000))
/* Max. integer delay with a 8 bit counter (ms) */
/* at 16 MHz --> 16 ms */
#define MAX_DELAY_8BIT ((256 * P_TC0) / 1000)
/* calculate the 8bit counter value from the
   wanted delay T in (ms) */
#define CTR_8BIT(T) (256 - (((T) * 1000) / P_TC0) + 1)

/*
 * Initialize the services module
 * Should be called first, in case other
 * init-routines call _delay_ms()
 */
extern void services_init(void);

/*
 * Delay about 't' ms, busy wait !
 * 1 <= 't' <= 255
 */
extern void _delay_ms(unsigned char t);

#endif //_SERVICES_H
